(
	-- RGB Multiply

    struct AMGData 
	(
		fn GetUUID mtl context = 
		(
			"129a5bfc-72e3-4e69-bc0f-7dcc5a2adf26"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			local out = "result"
			if (context == 1) do out = "normalPerturb" -- bump mode
			
			if mtl.map1 != undefined and mtl.map1enabled do 
			(
				append res #("Color1", mtl.map1, out)
				append res #("Alpha1", mtl.map1, "alpha")
				append res #("Float1", mtl.map1, "resultFloat")
			)
			if mtl.map2 != undefined and mtl.map2enabled do 
			(
				append res #("Color2", mtl.map2, out)
				append res #("Alpha2", mtl.map2, "alpha")
				append res #("Float2", mtl.map2, "resultFloat")
			)

			append res #("UVW",      mtl.coords, "result")
			append res #("utangent", mtl.coords, "utangent") 
			append res #("vtangent", mtl.coords, "vtangent") 
			append res #("wtangent", mtl.coords, "wtangent") 

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			append res #("Color1", mtl.color1)
			append res #("Color2", mtl.color2)
			append res #("Alpha1", 1.0)
			append res #("Alpha2", 1.0)
			append res #("Float1", (mtl.color1.r+mtl.color1.g+mtl.color1.b)/768.0)
			append res #("Float2", (mtl.color2.r+mtl.color2.g+mtl.color2.b)/768.0)
			append res #("Map1on", mtl.map1 != undefined and mtl.map1enabled)
			append res #("Map2on", mtl.map2 != undefined and mtl.map2enabled)

			append res #("scale",     1.0/mtl.size)
			append res #("levels",    mtl.levels)
			append res #("lowThresh", mtl.thresholdLow)
			append res #("hiThresh",  mtl.thresholdHigh)
			append res #("type",      mtl.type)
			append res #("phase",     mtl.phase)

			-- Output parameters
			append res #( "invert",			mtl.output.invert)                   
			append res #( "clamp",			mtl.output.clamp )  
			append res #( "rgb_level",		mtl.output.RGB_Level )  
			append res #( "rgb_offset",		mtl.output.RGB_Offset )  
			append res #( "out_amount",		mtl.output.Output_Amount )  
			append res #( "bump_amount",	mtl.output.Bump_Amount)  
			append res #( "alpha_from_rgb",	mtl.output.alphaFromRGB)  
			append res #( "curves",			mtl,   "output" )  -- Attach and translate the "output" rollout
				
 			res
		)
	)
	AMGData()
)
